package usb4allConfigGenerator;

import java.util.Vector;

public class UsbSharedMemAllocator {
	private static final String ls = System.getProperty("line.separator");
	
	private DeviceDescriptor dd;

	public UsbSharedMemAllocator(DeviceDescriptor dd) {
		super();
		// TODO Auto-generated constructor stub
		this.dd = dd;
	}
	
	public Vector<Endpoint> getAllEndpoints(){
		//TODO hacerlo bien para soportar mas configuraciones e interfaces
		Vector<Endpoint> endpoints = dd.getConfigurations().elementAt(0).getInterfaces().elementAt(0).getEndpoints();
		//supongo que en Endpoint estan todos los endpoints del dispositivo (sin repeticiones)
		return endpoints;
	}
	
    public int getMAX_EP_NUMBER(){
    	//	TODO hacerlo para otros ppBuffering mas alla del 0
		//TODO pensar partroon Strategy
    	Vector<Endpoint> endpoints = getAllEndpoints();
    	int maxEpNum=1; //por lo menos siempre esta el endpoint del admin module
		for (int i=0 ; i<endpoints.size(); i++){
			int epNumber = endpoints.elementAt(i).getEndpointNumber();
			if (epNumber>maxEpNum) maxEpNum = epNumber;
		}
		return maxEpNum;
    }
	
	public String getUsbEndpointBuffers(int ppBuffering){
		StringBuffer sb = new StringBuffer();
		//TODO hacerlo para otros ppBuffering mas alla del 0
		//TODO pensar partroon Strategy
		Vector<Endpoint> endpoints = getAllEndpoints();
    	for (int i=0 ; i<endpoints.size(); i++){
			int epNumber = endpoints.elementAt(i).getEndpointNumber();
			int epSize = endpoints.elementAt(i).getEndpointSize();
			int epDirection = endpoints.elementAt(i).getDirection();
			sb.append("volatile far byte "+getEndpointBufferName(epNumber,epDirection,ppBuffering)+ "["+epSize+"];"+ls);

		}
		return sb.toString();
	}
	private String getEndpointBufferName(int epNumber,int epDirection,int ppBuffering){
		//TODO hacerlo para otros modos de buffering
		return "ep"+epNumber+"_"+(epDirection==Endpoint.OUT ? "out" : "in")+"_buffer";
	}
	
	public String getUSBInitEPs(int ppBuffering){
		StringBuffer sb = new StringBuffer();
		//TODO hacerlo para otros ppBuffering mas alla del 0
		//TODO pensar partroon Strategy
		Vector<Endpoint> endpoints = getAllEndpoints();
    	//firma de la funcion
		sb.append("void USBInitEPs(void){"+ls);
		
		for (int i=0 ; i<endpoints.size(); i++){
			int epNumber = endpoints.elementAt(i).getEndpointNumber();
			int epDirection = endpoints.elementAt(i).getDirection();
			int epSize = endpoints.elementAt(i).getEndpointSize();
			int epType = endpoints.elementAt(i).getEndpointType();
			//seteo el uep
			if (epDirection==Endpoint.OUT){
			//TODO hacer que la linea siguiente aparezca en funcion de si tiene endpoints de IN y OUT a la vez 
				if (epType==Endpoint.ISOCHRONOUS){
					//no tiene handshake
					//sb.append(getUEP(epNumber)+ " = EP_OUT_IN;             // Enable 2 data pipes"+ls);
					//TODO ver bien como configurar, por ahora queda igual que los otros tipos de endpoint
					sb.append(getUEP(epNumber)+ " = EP_OUT_IN|HSHK_EN;             // Enable 2 data pipes"+ls);
				}
				else {
					//tiene handshake
					sb.append(getUEP(epNumber)+ " = EP_OUT_IN|HSHK_EN;             // Enable 2 data pipes"+ls);
				}
				sb.append(dd.getEpBDT(epNumber,epDirection)+".Cnt = sizeof("+getEndpointBufferName(epNumber,epDirection,0)+");     // Set buffer size" + ls +
				dd.getEpBDT(epNumber,epDirection)+".ADR = (byte*)&"+getEndpointBufferName(epNumber,epDirection,0)+";     // Set buffer address" + ls +
				dd.getEpBDT(epNumber,epDirection)+".Stat._byte = _USIE|_DAT0|_DTSEN;// Set status"+ls);
			}
			else {
				sb.append(dd.getEpBDT(epNumber,epDirection)+".ADR = (byte*)&"+getEndpointBufferName(epNumber,epDirection,0)+";      // Set buffer address"+ls+
				dd.getEpBDT(epNumber,epDirection)+".Stat._byte = _UCPU|_DAT1;      // Set buffer status"+ls);
			}
		}
		//inicializo maquina de estado para el ep0
		sb.append(ls);
		sb.append("boot_trf_state = WAIT_FOR_CMD;"+ls);

		//cierro la funcion
		sb.append("}//end USBGenInitEP"+ls);

		//termino con el archivo
		sb.append("	#pragma code sys"+ls);
		return sb.toString();
	}
	
	private String getUEP(int epNumber){
		return "UEP"+epNumber;
	}
	
	public String getBDTsExterns(int ppBuffering){
		StringBuffer sb = new StringBuffer();
		//TODO hacerlo para otros ppBuffering mas alla del 0
		int maxEpNum = getMAX_EP_NUMBER();
		//TODO mejorar para que solo deje extern lo que se usa
		for (int i=0; i<16; i++){
			sb.append("extern volatile far BDT ep"+i+"Bo;          //Endpoint #"+i+" BD Out" +ls+
					"extern volatile far BDT ep"+i+"Bi;          //Endpoint #"+i+" BD In"+ls);
		}
		sb.append(ls);    
		return sb.toString();
	}
	
	public String getUSBBuffersExterns(int ppBuffering){
		StringBuffer sb = new StringBuffer();
		//TODO hacerlo para otros ppBuffering mas alla del 0
		Vector<Endpoint> endpoints = getAllEndpoints();
		for (int i=0 ; i<endpoints.size(); i++){
			int epNumber = endpoints.elementAt(i).getEndpointNumber();
			int epDirection = endpoints.elementAt(i).getDirection();
			int epSize = endpoints.elementAt(i).getEndpointSize();
			sb.append("extern volatile far byte "+getEndpointBufferName(epNumber,epDirection,0)+
					"["+epSize+"];"+ls);
		}
		return sb.toString();
	}
}